<?php
//PHP Template tutorial
//Author: Joshua Bolduc
//Date: 08/01/2007

class template
{
/*********************************************************************
VARIABLES 
Setting our variables 
*********************************************************************/
	var $template; 				//The template name
	var $template_string;    	//The template string will be stored here
	var $prefix    = "{"; 		//The variable prefix character.
	var $suffix    = "}"; 		//The variable suffix character.
	var $var_array = array(); 	//The values of your variables will be stored here
	
/*********************************************************************
SET TEMPLATE
This function sets the file that we are going to be grabbing our 
html from
*********************************************************************/
	function set_template($filename)
	{
		$this->template = $filename; 
	}
/*********************************************************************
SET VARS
This function sets a value for a variable
*********************************************************************/
	function set_var($name, $value)
	{
		//storing our variable and its value into an array
		$this->var_array[$name] = $value; 
	}
/*********************************************************************
LOAD FILE
This function loads the contents of the template
file into a string.
*********************************************************************/
	function load_file()
	{
		//saving its contents into a string		
		$this->template_string = file_get_contents($this->template);
	}
/*********************************************************************
REPLACE VARS
This function replaces the variables with 
it's corresponding values 
*********************************************************************/
	function replace_vars()
	{
		//The foreach loop is very useful when we want to loop through
		//associative arrays. 
		foreach($this->var_array as $assoc => $value)
		{
			//appending the variable prefixes to match. ex: {VAR_NAME} 
			$var_name = $this->prefix.$assoc.$this->suffix; 
			
			//replacing every instance of the variable with it's corresponding value. 
			//so {VAR_NAME} becomes "this is my variable" 
			$this->template_string = str_replace($var_name, $value, $this->template_string); 
		}
	}
/*********************************************************************
PARSE
This function calls the actions and outputs the
final result. 
*********************************************************************/
	 function parse()
	{
		//loading the file 
		$this->load_file(); 
		
		//setting the variables 
		$this->replace_vars(); 
		
		//outputting the newly parsed template :) 
		return $this->template_string; 
	}
}
?>